#ifndef CRFEPURDIALOG_H
#define CRFEPURDIALOG_H

#include <QDialog>
#include "../ui/ConfigDialog.h"

#include <def.h>

class QrfeReaderInterface;
class QrfeRfePurReader;

class QrfeProgressDialog;

namespace Ui
{
	class CRfePurDialogClass;
};

class CRfePurRfSettings;

class QCheckBox;
class QSpinBox;



class CRfePurDialog : public QDialog, ConfigDialog
{
    Q_OBJECT

    typedef struct {
        QWidget* 			on;
        QCheckBox*			onBox;
        QWidget*			time;
        QSpinBox*			timeBox;
    } AntennaSequenceGuiElems;

    typedef struct {
        bool 	on;
        uchar	antennaNr;
        uint 	time;
    } AntennaSequenceInfos;

public:
    CRfePurDialog(QWidget *parent = 0);
    ~CRfePurDialog();

public slots:
	int exec ( QrfeReaderInterface* ph, bool fullFunction = true );
	virtual void done(int r);

	bool writeAll();
	void refresh();

	bool setReaderName();
	bool setReaderLocation();
	bool setInventoryMode();
	bool setPowerSafe();
	bool setSendRSSI();
	bool setSendFrequency();
	bool setTagIdHandler();
	bool setPostDetectReadParams();

	bool readGPIOInfos();
	void setGPIOLevel(bool high);
	void setGPIODirection();
	void reloadGPIODirection();
	void reloadGPIOValues();

	bool readAntennaSequence();
	void reloadAntennaSequence();
	void insertAntenna(uchar antennaNr, bool on, uint time);
	void antennaWasChanged ( bool on );
	void antennaTimeChanged ( int time );
	void antennaClicked ( int row, int /*column*/ );
	void moveAntennaUp();
	void moveAntennaDown();
    void fillAntennaSequence();
	bool setAntennaSequence();


	void storeSettings();
	void restoreFactory();

	void rebootDevice();
	void updateDevice();

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

public:
	bool writeSettingsToReader( QrfeProgressDialog* pb);
	bool readSettingsFromReader( QrfeProgressDialog* pb);

private:
	QrfeRfePurReader* 		m_reader;
    Ui::CRfePurDialogClass*	m_ui;

    bool 					m_reloadGPIODirection;
    bool                    m_reloadGPIOValues;

    CRfePurRfSettings*		m_rfSettings;

    QList<AntennaSequenceInfos>		m_antennaSequence;
	QList<AntennaSequenceGuiElems>	m_antennaSequenceGuiElems;
};

#endif // CRFEPURDIALOG_H
